<?php

// InSim structure reader. 8.01.2008
// Dmitri Lebedev aka detail, detail@ngs.ru http://ryba4.com

/*
   This script opens the already prepared file insim_structure.serialize,
   loads the data into memory and defines all the necessary constants.
   The .serialize file has to be prepared by parse_insim.txt.php script.
   If none of those is present, search LFS forum for the package or visit my website.
   
   Made FOR inclusion in an app.
*/

$LFS_DATA = unserialize(implode("", file("insim_structure.serialize")));

// flags
foreach($LFS_DATA[0] as $key1 => $val1)
	define($key1, $val1);

// enums
foreach($LFS_DATA[1] as $val1)
	for ($i = 0; $i < sizeof($val1); $i++)
	{
		define($val1[$i], $i);

		/*
			This is needed to create names for user callback functions.
			They are generated for all the names, even though this is not needed.
			For example, for ISP_MSO there will be a constant:
			define("function_ISP_11", "ISP_MSO");
			
			User will need to declare a function ISP_MSO to operate this packet.
			phpInSim will recieve a packet with 11 in the second byte and will
			address to a constant called function_ISP_11, in which there will be the
			function's name.
		*/
		if (preg_match("~^(ISP|TINY|SMALL)_~", $val1[$i], $match))
			define("function_". $match[1]. "_". constant($val1[$i]), $val1[$i]);
	}

// structures
$LFS_STRUCT = $LFS_DATA[2];
$LFS_STRING = $LFS_DATA[3];
$LFS_USTRING = $LFS_DATA[4];

unset($LFS_DATA, $key1, $val1, $i);

/*
I thought of a state-keeping in memory and made a list of packets that have to be copied or analyzed for that. Right now I think this is not a good idea, at lest it is not for this stage.

$STORED_ISP = array(ISP_VER, ISP_STA, ISP_ISM, ISP_VTN, ISP_RST, ISP_NCN, ISP_CNL,
ISP_NPL, ISP_PLP, ISP_PLL, ISP_LAP, ISP_SPX, ISP_PIT, ISP_PSF, ISP_PLA, ISP_PEN,
ISP_TOC, ISP_PFL, ISP_FIN, ISP_RES, ISP_REO, ISP_AXI, ISP_AXO, ISP_NLP, ISP_MCI);
$STORED_TINY = array(TINY_VTC, TINY_CLR, TINY_REN);
$STORED_SMALL = array(SMALL_VTA);
*/